package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Request;

public class OEFOIFScrambledDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {

    @Override
    public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Location site,
            final boolean isIndependentOnly) {

        if (temp.getName().startsWith(NDS_DATA_USE_AGREEMENT) && req.getPrimaryLocation().getId() == site.getId()
                && admin.getName().equals(DART_NDS_ADMINISTRATORS)) {
            return true;
        }

        if (temp.getName().startsWith(RESEARCH_PRIVACY_REVIEW_CHECKLIST) && req.getPrimaryLocation().getId() == site.getId()
                && admin.getName().equals(DART_PRIVACY_ADMINISTRATORS)) {
            return true;
        }

        // Note: currently unused
        if (temp.getName().startsWith("VSSC OEF/OIF Roster File DUA") && req.getPrimaryLocation().getId() == site.getId()
                && admin.getName().equals("DART VSSC Administrators")) {
            return true;
        }

        //
        // 5/21/2014: upload the OEF-OIF Data Use Agreement in the Admin Documents tab
        // Data Use Agreement is required for the primary site
        if (temp.getName().startsWith("OEF-OIF Data Use Agreement") && req.getPrimaryLocation().getId() == site.getId()
                && admin.getName().equals("OEF-OIF Administrators")) {
            return true;
        }

        return false;
    }

    @Override
    public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Participant participant,
            final boolean isIndependentOnly) {

        return false;
    }
}
